<?php
/**
 * JNews Paywall - Backend Menu Template
 */

if ( ! function_exists( 'jpw_menu' ) ) {
	add_action( 'admin_menu', 'jpw_menu' );

	/**
	 * JPW Menu
	 **/
	function jpw_menu() {

		/* add_submenu_page('post-paywall', 'General', 'General', 'manage_options', 'post-paywall', 'jpw_general', 'post-paywall'); */

		if ( current_user_can( 'administrator', get_current_user_id() ) ) {
			$query['autofocus[section]'] = 'jnews_paywall_section';
			$section_link                = add_query_arg( $query, admin_url( 'customize.php' ) );

			add_menu_page( 'JNews Paywall', 'JNews Paywall', 'manage_options', 'post-paywall', 'jpw_status' );
			add_submenu_page( 'post-paywall', 'Subscribers Status', 'Users Status', 'manage_options', 'post-paywall', 'jpw_status' );
			add_submenu_page( 'post-paywall', 'Customizer Setting', 'Customizer Setting', 'manage_options', $section_link );
		} else {
			add_menu_page( 'Premium Status', 'Premium Status', 'manage_options', 'post-paywall', 'jpw_status' );
			add_submenu_page( 'post-paywall', 'Subscription', 'Subscription', 'read', 'my-subscription', 'jpw_subscribe' );
			add_submenu_page( 'post-paywall', 'Unlocked Posts', 'Unlocked Posts', 'read', 'unlocked-posts', 'jpw_unlock' );
		}
	}
}

/**
 * Admin Menu
 */
function jpw_status() {
	$user_query = new WP_User_Query( [ '' ] );
	$users      = $user_query->get_results();

	$userlist = '<table class=\'jpw-subscriber widefat striped\' style=\'width:99%\'>
                    <tr>
                        <th>' . esc_html__( 'Username', 'jnews-paywall' ) . '</th>
                        <th>' . esc_html__( 'Full Name', 'jnews-paywall' ) . '</th>
                        <th>' . esc_html__( 'Email', 'jnews-paywall' ) . '</th>
                        <th>' . esc_html__( 'Subscription Status', 'jnews-paywall' ) . '</th>
                        <th>' . esc_html__( 'Times Left', 'jnews-paywall' ) . '</th>
						<th>' . esc_html__( 'Expiration Date', 'jnews-paywall' ) . '</th>
						<th>' . esc_html__( 'Unlock Remaining', 'jnews-paywall' ) . '</th>
                    </tr>';

	foreach ( $users as $user ) {
		$status           = get_user_option( 'jpw_subscribe_status', $user->ID );
		$expired          = get_user_option( 'jpw_expired_date', $user->ID ) ? get_user_option( 'jpw_expired_date', $user->ID ) : Date( 'F d, Y' );
		$unlock_remaining = get_user_option( 'jpw_unlock_remaining', $user->ID ) ? get_user_option( 'jpw_unlock_remaining', $user->ID ) : 0;
		$days             = date_diff( new DateTime(), new DateTime( $expired ) );
		$current_date     = new DateTime();
		$expired_date     = new DateTime( $expired );

		if ( $status && 'ACTIVE' === $status ) {
			if ( $current_date <= $expired_date ) {
				$status_user = 'Subscribed';
				$days_left   = $days->format( '%a days %H hours' );
			} else {
				update_user_option( $user->ID, 'jpw_subscribe_status', false );
				$status_user = 'Not Subscribe';
				$days_left   = '&ndash;';
				$expired     = '&ndash;';
			}
		} else {
			$status_user = 'Not Subscribe';
			$days_left   = '&ndash;';
			$expired     = '&ndash;';
		}

		if ( get_user_option( 'first_name', $user->ID ) || get_user_option( 'last_name', $user->ID ) ) {
			$name = get_user_option( 'first_name', $user->ID ) . ' ' . get_user_option( 'last_name', $user->ID );
		} else {
			$name = '—';
		}

		$userlist .= '<tr>
                        <td>' . get_avatar( $user->ID, 32 ) . '<a class=\'username\' href=\'' . get_bloginfo( 'url' ) . '?author=' . $user->ID . '\' >' . $user->user_login . '</a></td>
                        <td>' . $name . '</td>
                        <td>' . $user->user_email . '</td>
                        <td>' . $status_user . '</td>
                        <td>' . $days_left . '</td>
						<td>' . ( ( ! empty( $status ) && $status ) ? Date( 'F d, Y', strtotime( $expired ) ) : $expired ) . '</td>
						<td>' . $unlock_remaining . '</td>
                    </tr>';

	}
	$userlist .= '</table>';

	$menu_status = '<div class=\'jpw_manage_status\'>
                        <h3>' . esc_html__( 'Post Paywall Users Status', 'jnews-paywall' ) . '</h3>
                        <p>' . esc_html__( 'Here you can monitor your Post Paywall Subscriber latest status.', 'jnews-paywall' ) . '</p>
                        <br/><br/>
                        ' . $userlist . '
                    </div>';

	echo $menu_status;
}

/**
 * User Menu : Subscription Status
 */
function jpw_subscribe() {
	$status    = get_user_option( 'jpw_subscribe_status', get_current_user_id() );
	$paypal_id = get_user_option( 'jpw_paypal_subs_id', get_current_user_id() );
	$expired   = get_user_option( 'jpw_expired_date', get_current_user_id() ) ? get_user_option( 'jpw_expired_date', get_current_user_id() ) : Date( 'F d, Y' );
	$remaining = date_diff( new DateTime(), new DateTime( $expired ) );

	if ( $paypal_id ) {
		$sub_id   = $paypal_id;
		$sub_type = 'Paypal';
	}

	if ( $status && $status === 'ACTIVE' ) {
		$mystatus = '<div class=\'jpw_leftbox\'>
							<span><strong>' . esc_html__( 'Subscription ID', 'jnews-paywall' ) . ' : </strong>' . $sub_id . '</span>
							<span><strong>' . esc_html__( 'Subscription Status', 'jnews-paywall' ) . ' : </strong>' . $status . '</span>
							<span><strong>' . esc_html__( 'Remaining Time', 'jnews-paywall' ) . ' : </strong>' . $remaining->format( '%a days %h hours' ) . '</span>
							<span><strong>' . esc_html__( 'Next Payment Due', 'jnews-paywall' ) . ' : </strong>' . Date( 'F d, Y', strtotime( $expired ) ) . '</span>
							<span><strong>' . esc_html__( 'Payment Type', 'jnews-paywall' ) . ' : </strong>' . $sub_type . '</span>
						</div>
						<div class=\'jpw_rightbox\'>
							<button class=\'subscription\'>' . esc_html__( 'Cancel Subscription', 'jnews-paywall' ) . '</button>
						</div>';
	} else {
		$mystatus = '<span>' . esc_html__( 'You are not subscribed', 'jnews-paywall' ) . '</span>';
	}

	$output = '<div class=\'jpw_manage_status subscription\'>
					<h2>' . esc_html__( 'Subscription Status', 'jnews-paywall' ) . '</h2>
					<div class=\'jpw_boxed\'>
						' . $mystatus . '
					</div>
				</div>';

	echo $output;
}

/**
 * User Menu : Unlocked Posts
 */
function jpw_unlock() {
	$unlock_remaining = get_user_option( 'jpw_unlock_remaining', get_current_user_id() ) ? get_user_option( 'jpw_unlock_remaining', get_current_user_id() ) : 0;
	$unlocked_posts   = get_user_option( 'jpw_unlocked_post_list', get_current_user_id() ) ? get_user_option( 'jpw_unlocked_post_list', get_current_user_id() ) : [];
	$post_list        = '';
	$post_total       = 0;

	if ( ! empty( $unlocked_posts ) ) {
		foreach ( $unlocked_posts as $post_id ) {
			$post_list .= '<tr>
								<td><a href=\'' . get_permalink( $post_id ) . '\'>' . get_the_title( $post_id ) . '</a></td>
							</tr>';
			$post_total ++;
		}
	} else {
		$post_list .= '<tr>
						<td>' . esc_html__( 'You don\'t have any post unlocked', 'jnews-paywall' ) . '</td>
					</tr>';
	}

	$output = '<div class=\'jpw_manage_status unlock\'>
					<h2>' . esc_html__( 'Unlocked Posts', 'jnews-paywal' ) . '</h2>
					<div class=\'jpw_boxed\'>
						<span><strong>' . esc_html__( 'Quotas Left', 'jnews-paywall' ) . ' : </strong>' . $unlock_remaining . ' unlocks</span>
						<span><strong>' . esc_html__( 'Posts Owned', 'jnews-paywall' ) . ' : </strong>' . $post_total . ' posts</span>
					</div>
					<br/>
					<table class=\'jpw-subscriber widefat striped\' style=\'width:66%\'>
						<tr>
							<th>' . esc_html__( 'Unlocked Posts Collection', 'jnews-paywall' ) . '</th>
						</tr>
						' . $post_list . '
					</table>
				</div>';

	echo $output;
}
