var vendor = function() {
    return "[vendor]";
};
if (Object.defineProperty) {
    Object.defineProperty(navigator, "vendor", {
        get: vendor
    });
} else if (Object.prototype.__defineGetter__) {
    navigator.__defineGetter__("vendor", vendor);
}

var hist = function() {
    return [history.length];
};
if (Object.defineProperty) {
    Object.defineProperty(window.history, "length", {
        get: hist
    });
} else if (Object.prototype.__defineGetter__) {
    window.history.__defineGetter__("length", hist);
}

var hardware = function() {
    return [hardware.concurrency];
};
if (Object.defineProperty) {
    Object.defineProperty(navigator, "hardwareConcurrency", {
        get: hardware
    });
} else if (Object.prototype.__defineGetter__) {
    navigator.__defineGetter__("hardwareConcurrency", hardware);
}

var device = function() {
    return [device.memory];
};
if (Object.defineProperty) {
    Object.defineProperty(navigator, "deviceMemory", {
        get: device
    });
} else if (Object.prototype.__defineGetter__) {
    navigator.__defineGetter__("deviceMemory", device);
}

var oscpu = function() {
    return "[oscpu]";
};
if (Object.defineProperty) {
    Object.defineProperty(navigator, "oscpu", {
        get: oscpu
    });
} else if (Object.prototype.__defineGetter__) {
    navigator.__defineGetter__("oscpu", oscpu);
}

if (Object.defineProperty) {
    Object.defineProperty(navigator, "webdriver", {
        get: undefined
    });
} else if (Object.prototype.__defineGetter__) {
    navigator.__defineGetter__("webdriver", undefined);
}

var pluginArray = Object.create(PluginArray.prototype)
var pluginsLeng = function() {
    return 0;	
};
if (Object.defineProperty) {
    Object.defineProperty(pluginArray, "length", {
        get: pluginsLeng
    });
} else if (Object.prototype.__defineGetter__) {
    pluginArray.__defineGetter__("length", pluginsLeng);
}
var plugin = function() {
    return pluginArray;
};
if (Object.defineProperty) {
    Object.defineProperty(navigator, "plugins", {
        get: plugin
    });
} else if (Object.prototype.__defineGetter__) {
    navigator.__defineGetter__("plugins", plugin);
}

var mimeTypesArray = Object.create(MimeTypeArray.prototype)
var mimeTypesLeng = function() {
    return 0;	
};
if (Object.defineProperty) {
    Object.defineProperty(mimeTypesArray, "length", {
        get: mimeTypesLeng
    });
} else if (Object.prototype.__defineGetter__) {
    mimeTypesArray.__defineGetter__("length", mimeTypesLeng);
}
var mimeTypes = function() {
    return mimeTypesArray;
};
if (Object.defineProperty) {
    Object.defineProperty(navigator, "mimeTypes", {
        get: mimeTypes
    });
} else if (Object.prototype.__defineGetter__) {
    navigator.__defineGetter__("mimeTypes", mimeTypes);
}

function fakeCharging() {
    return [true, true, true, true, true, true, false, false][Math.floor(Math.random() * 7)];
}

function fakeChargingTime() {
    var dt2 = Math.floor(Math.random() * 6100) + 1200;
    return [dt2, Infinity, 0, 0, 0, 0, 0, 0, Infinity, Infinity, 0, 0, 0, 0, dt2][Math.floor(Math.random() * 15)];
}

function fakeDischargingTime() {
    var dt = Math.floor(Math.random() * 7000) + 1150;
    return [Infinity, Infinity, Infinity, Infinity, Infinity, Infinity, Infinity, dt, dt, dt, dt][Math.floor(Math.random() * 9)];
}

function fakeLevel() {
    return [1, 1, 1, 1, 1, 1, 1, 1, 56.99999999999999, 57.99999999999999, 58.99999999999999, 58.99999999999999, 70.99999999999999, 0.84, 0.77, 0.99, 0.98, 0.98, 0.98, 0.99, 0.98, 0.97, 0.96, 0.95, 0.94, 0.93, 0.92, 0.91, 0.90, 0.89, 0.88, 0.87, 0.86, 0.76, 0.65, 0.48, 0.73, 0.74, 0.75][Math.floor(Math.random() * 28)];

}

const fakeChargingValue = fakeCharging();
const fakeLevelValue = fakeLevel();
const fakeDischargingValue = fakeDischargingTime();
const fakeChargingTimeValue = fakeChargingTime();

Object.defineProperties(BatteryManager.prototype, {
    charging: {
        configurable: true,
        enumerable: true,
        get: function getCharging() {


            return fakeChargingValue;
        }
    },


    chargingTime: {
        configurable: true,
        enumerable: true,
        get: function getChargingTime() {


            return fakeChargingTimeValue;
        }
    },

    dischargingTime: {
        configurable: true,
        enumerable: true,
        get: function getDischargingTime() {

            return fakeDischargingValue;
        }
    },


    level: {
        configurable: true,
        enumerable: true,
        get: function getLevel() {


            return fakeLevelValue;
        }
    }
});



screen = new function() {
    this.colorDepth = [color.depth];
    this.pixelDepth = [pixel.depth]
};


webkitRTCPeerConnection = undefined;
RTCPeerConnection = undefined;

var _is_chrome = [chrome_browser];

if (_is_chrome == false){
	Chrome = undefined;
	chrome = undefined;
	delete(Chrome);
}

var _webgl = [webgl];

if (_webgl == true) {
    var BR0WSERplugsGL2 = {
        [key]: "[value]"
    };

    var getBPugsGL = WebGL2RenderingContext.prototype.getParameter;
    WebGL2RenderingContext.prototype.getParameter = function(e) {
        return BR0WSERplugsGL2[e] ? BR0WSERplugsGL2[e] : getBPugsGL.apply(this, arguments)
    };
    var getBPugsGLx = WebGLRenderingContext.prototype.getParameter;
    WebGLRenderingContext.prototype.getParameter = function(e) {
        return BR0WSERplugsGL2[e] ? BR0WSERplugsGL2[e] : getBPugsGLx.apply(this, arguments)
    };
}

var _canvas = [canvas];

if (_canvas == true) {
    const toBlob = HTMLCanvasElement.prototype.toBlob;
    const toDataURL = HTMLCanvasElement.prototype.toDataURL;
    const getImageData = CanvasRenderingContext2D.prototype.getImageData;
    //
    var noisify = function(canvas, context) {
        const shift = {
            'r': [canvasnoiseone],
            'g': [canvasnoisetwo],
            'b': [canvasnoisethree],
            'a': [canvasnoisefour]
        };
        //
        const width = canvas.width,
            height = canvas.height;
        const imageData = getImageData.apply(context, [0, 0, width, height]);
        for (let i = 0; i < height; i++) {
            for (let j = 0; j < width; j++) {
                const n = ((i * (width * 4)) + (j * 4));
                imageData.data[n + 0] = imageData.data[n + 0] + shift.r;
                imageData.data[n + 1] = imageData.data[n + 1] + shift.g;
                imageData.data[n + 2] = imageData.data[n + 2] + shift.b;
                imageData.data[n + 3] = imageData.data[n + 3] + shift.a;
            }
        }
        //
        window.top.postMessage("canvas-fingerprint-defender-alert", '*');
        context.putImageData(imageData, 0, 0);
    }
    Object.defineProperty(HTMLCanvasElement.prototype, "toBlob", {
        "value": function() {
            noisify(this, this.getContext("2d"));
            return toBlob.apply(this, arguments);
        }
    });
    //
    Object.defineProperty(HTMLCanvasElement.prototype, "toDataURL", {
        "value": function() {
            noisify(this, this.getContext("2d"));
            return toDataURL.apply(this, arguments);
        }
    });
    //
    Object.defineProperty(CanvasRenderingContext2D.prototype, "getImageData", {
        "value": function() {
            noisify(this.canvas, this);
            return getImageData.apply(this, arguments);
        }
    });

    function defineobjectproperty(val, e, c, w) {
        // Makes an object describing a property
        return {
            value: val,
            enumerable: !!e,
            configurable: !!c,
            writable: !!w
        }
    }


}

var _fonts = [fonts];

if (_fonts == true) {

    var originalStyleSetProperty = CSSStyleDeclaration.prototype.setProperty
    var originalSetAttrib = Element.prototype.setAttribute
    var originalNodeAppendChild = Node.prototype.appendChild

    var DEFAULT = 'auto';

    var baseFonts = ["default"]

    var FontWhiteList = ["fonts"].map(function(x) {
        return x.toLowerCase()
    })


    var keywords = ["inherit", "auto", "default", "!Important"]


    baseFonts.push.apply(baseFonts, FontWhiteList)
    baseFonts.push.apply(baseFonts, keywords)


    function getAllowedFontFamily(family) {
        var fonts = family.replace(/"|'/g, '').split(',')
        var allowedFonts = fonts.filter(function(font) {
            if (font && font.length) {
                var normalised = font.trim().toLowerCase()
                // Allow base fonts
                for (var allowed of baseFonts)
                    if (normalised == allowed) return true
                // Allow web fonts
                for (var allowed of document.fonts.values())
                    if (normalised == allowed) return true
            }
        })
        return allowedFonts.map(function(f) {
            var trimmed = f.trim()
            return ~trimmed.indexOf(' ') ? "'" + trimmed + "'" : trimmed
        }).join(", ")
    }


    function modifiedCssSetProperty(key, val) {
        if (key.toLowerCase() == 'font-family') {
            var keyresult = key.toLowerCase()
            var allowed = getAllowedFontFamily(val)

            return originalStyleSetProperty.call(this, 'font-family', allowed || DEFAULT)
        }
        return originalStyleSetProperty.call(this, key, val)
    }

    function makeModifiedSetCssText(originalSetCssText) {
        return function modifiedSetCssText(css) {
            var fontFamilyMatch = css.match(/\b(?:font-family:([^;]+)(?:;|$))/i)
            if (fontFamilyMatch && fontFamilyMatch.length == 1) {
                css = css.replace(/\b(font-family:[^;]+(;|$))/i, '').trim()
                var allowed = getAllowedFontFamily(fontFamilyMatch[1]) || DEFAULT
                if (css.length && css[css.length - 1] != ';')
                    css += ';'
                css += "font-family: " + allowed + ";"
            }
            return originalSetCssText.call(this, css)
        }
    }

    var modifiedSetAttribute = (function() {
        var innerModify = makeModifiedSetCssText(function(val) {
            return originalSetAttrib.call(this, 'style', val)
        })
        return function modifiedSetAttribute(key, val) {
            if (key.toLowerCase() == 'style') {
                return innerModify.call(this, val)
            }
            return originalSetAttrib.call(this, key, val)
        }
    })();

    function makeModifiedInnerHTML(originalInnerHTML) {
        return function modifiedInnerHTML(html) {
            //Add as normal, then fix before returning
            var retval = originalInnerHTML.call(this, html)
            recursivelyModifyFonts(this.parentNode)
            return retval
        }
    }

    function recursivelyModifyFonts(elem) {
        if (elem) {
            if (elem.style && elem.style.fontFamily) {
                modifiedCssSetProperty.call(elem.style, 'font-family', elem.style.fontFamily) // Uses the special setter
            }
            if (elem.childNodes)
                elem.childNodes.forEach(recursivelyModifyFonts)
        }
        return elem
    }

    function modifiedAppend(child) {
        child = recursivelyModifyFonts(child)
        return originalNodeAppendChild.call(this, child)
    }

    var success = true

    function overrideFunc(obj, name, f) {
        try {
            Object.defineProperty(obj.prototype, name, defineobjectproperty(f, true))
        } catch (e) {
            success = false;
        }
    }

    function overrideSetter(obj, name, makeSetter) {
        try {
            var current = Object.getOwnPropertyDescriptor(obj.prototype, name)
            current.set = makeSetter(current.set)
            current.configurable = false
            Object.defineProperty(obj.prototype, name, current)
        } catch (e) {
            success = false;
        }
    }
    overrideFunc(Node, 'appendChild', modifiedAppend)
    overrideFunc(CSSStyleDeclaration, 'setProperty', modifiedCssSetProperty)
    overrideFunc(Element, 'setAttribute', modifiedSetAttribute)

    try {
        Object.defineProperty(CSSStyleDeclaration.prototype, "fontFamily", {
            set: function fontFamily(f) {
                modifiedCssSetProperty.call(this, 'font-family', f)
            },
            get: function fontFamily() {
                return this.getPropertyValue('font-family')
            }
        })
    } catch (e) {
        success = false;
    }


    overrideSetter(CSSStyleDeclaration, 'cssText', makeModifiedSetCssText)
    overrideSetter(Element, 'innerHTML', makeModifiedInnerHTML)
    overrideSetter(Element, 'outerHTML', makeModifiedInnerHTML)
}
